<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Invoice</title>
</head>
<body style="font-family: Arial, Helvetica, sans-serif; background:#f6f7fb; padding:24px;">
  <div style="max-width:720px; margin:0 auto; background:#fff; border-radius:12px; overflow:hidden; border:1px solid #eee;">
    <div style="padding:20px 24px; background:#111827; color:#fff;">
      <div style="font-size:18px; font-weight:700;">Invoice Pembelian</div>
      <div style="opacity:0.9; margin-top:6px;">
        Order #{{ $order_id }} • Invoice: {{ $invoice_number }} • Status: {{ $order_status_label }}
      </div>
    </div>

    <div style="padding:20px 24px;">
      <h3 style="margin:0 0 10px;">Detail Penerima</h3>
      <div style="line-height:1.6;">
        <div><b>Nama:</b> {{ $customer_name }}</div>
        <div><b>Telepon:</b> {{ $customer_phone }}</div>
        <div><b>Alamat:</b> {{ $delivery_address }} {!! $postal_code ? '('.e($postal_code).')' : '' !!}</div>
      </div>

      <hr style="border:none; border-top:1px solid #eee; margin:16px 0;">

      <h3 style="margin:0 0 10px;">Ringkasan Pesanan</h3>

      <table width="100%" cellpadding="0" cellspacing="0" style="border-collapse:collapse;">
        <thead>
          <tr>
            <th align="left" style="padding:10px; border-bottom:1px solid #eee;">Produk</th>
            <th align="center" style="padding:10px; border-bottom:1px solid #eee;">Qty</th>
            <th align="right" style="padding:10px; border-bottom:1px solid #eee;">Harga</th>
            <th align="right" style="padding:10px; border-bottom:1px solid #eee;">Subtotal</th>
          </tr>
        </thead>
        <tbody>
          @foreach ($items as $it)
            <tr>
              <td style="padding:10px; border-bottom:1px solid #f2f2f2;">
                <div style="font-weight:600;">{{ $it['product_name'] }}</div>
                <div style="font-size:12px; color:#6b7280;">Varian: {{ $it['variant_name'] ?: '-' }}</div>
              </td>
              <td align="center" style="padding:10px; border-bottom:1px solid #f2f2f2;">{{ $it['qty'] }}</td>
              <td align="right" style="padding:10px; border-bottom:1px solid #f2f2f2;">Rp {{ number_format($it['price'], 0, ',', '.') }}</td>
              <td align="right" style="padding:10px; border-bottom:1px solid #f2f2f2;">Rp {{ number_format($it['subtotal'], 0, ',', '.') }}</td>
            </tr>
          @endforeach
        </tbody>
      </table>

      <div style="margin-top:14px; display:flex; justify-content:flex-end;">
        <table cellpadding="0" cellspacing="0" style="border-collapse:collapse; width:320px;">
          <tr>
            <td style="padding:8px 0; color:#6b7280;">Subtotal</td>
            <td align="right" style="padding:8px 0;">Rp {{ number_format($subtotal, 0, ',', '.') }}</td>
          </tr>
          <tr>
            <td style="padding:8px 0; color:#6b7280;">Ongkir</td>
            <td align="right" style="padding:8px 0;">Rp {{ number_format($shipping_cost, 0, ',', '.') }}</td>
          </tr>
          <tr>
            <td style="padding:10px 0; font-weight:700; border-top:1px solid #eee;">Total</td>
            <td align="right" style="padding:10px 0; font-weight:700; border-top:1px solid #eee;">
              Rp {{ number_format($total, 0, ',', '.') }}
            </td>
          </tr>
        </table>
      </div>

      <hr style="border:none; border-top:1px solid #eee; margin:16px 0;">

      <h3 style="margin:0 0 10px;">Pengiriman</h3>
      <div style="line-height:1.6;">
        <div><b>Kurir:</b> {{ $shipping_courier ?? '-' }} ({{ $shipping_service ?? '-' }})</div>
        <div><b>No Resi:</b> {{ $tracking_number ?? '-' }}</div>
      </div>

      <div style="margin-top:16px; font-size:12px; color:#6b7280;">
        Dibuat: {{ $created_at ?? '-' }} • Dibayar: {{ $paid_at ?? '-' }}
      </div>
    </div>

    <div style="padding:14px 24px; background:#f9fafb; color:#6b7280; font-size:12px;">
      Jika ada pertanyaan, balas email ini.
    </div>
  </div>
</body>
</html>
