<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;

class BrandSeeder extends Seeder
{
    public function run(): void
    {
        $brands = [
            'Elixir','Erniball','Sheldon','AKA','Banana','Beatme',
            'Esper','Glow','James','Kuya','Lucido','Julea',
            'Million','Neo','Toledo','Yamaha','Ibanez','Tender','Daddario'
        ];

        foreach ($brands as $brand) {
            DB::table('brands')->insert([
                'name' => $brand,
                'slug' => Str::slug($brand),
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }
    }
}
