<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('otp_verifications', function (Blueprint $table) {
            $table->string('purpose', 30)->default('register')->after('email');
            $table->index(['email', 'purpose']);
        });
    }

    public function down(): void
    {
        Schema::table('otp_verifications', function (Blueprint $table) {
            $table->dropIndex(['email', 'purpose']);
            $table->dropColumn('purpose');
        });
    }
};
