<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Third Party Services
    |--------------------------------------------------------------------------
    |
    | This file is for storing the credentials for third party services such
    | as Mailgun, Postmark, AWS and more. This file provides the de facto
    | location for this type of information, allowing packages to have
    | a conventional file to locate the various service credentials.
    |
    */

    'mailgun' => [
        'domain' => env('MAILGUN_DOMAIN'),
        'secret' => env('MAILGUN_SECRET'),
        'endpoint' => env('MAILGUN_ENDPOINT', 'api.mailgun.net'),
        'scheme' => 'https',
    ],

    'postmark' => [
        'token' => env('POSTMARK_TOKEN'),
    ],

    'ses' => [
        'key' => env('AWS_ACCESS_KEY_ID'),
        'secret' => env('AWS_SECRET_ACCESS_KEY'),
        'region' => env('AWS_DEFAULT_REGION', 'us-east-1'),
    ],

    'midtrans' => [
    'server_key' => env('MIDTRANS_SERVER_KEY'),
    'client_key' => env('MIDTRANS_CLIENT_KEY'),
    'is_production' => env('MIDTRANS_IS_PRODUCTION', false),
    ],

        'biteship' => [
        'key' => env('BITESHIP_API_KEY'),
        'base_url' => env('BITESHIP_BASE_URL', 'https://api.biteship.com'),
        'webhook_secret' => env('BITESHIP_WEBHOOK_SECRET'),
        'shipper_name' => env('BITESHIP_SHIPPER_NAME', 'Doremi Store'),
        'shipper_phone' => env('BITESHIP_SHIPPER_PHONE', '081234567890'),
        'shipper_email' => env('BITESHIP_SHIPPER_EMAIL', 'store@example.com'),
        'shipper_org' => env('BITESHIP_SHIPPER_ORG', 'Doremi Store'),
        'origin_note' => env('BITESHIP_ORIGIN_NOTE', 'Pickup jam kerja'),
        // optional origin default (biar createOrderFromLocal gak kosong)
        'origin_postal_code' => env('BITESHIP_ORIGIN_POSTAL_CODE', ''),
        'origin_contact_name' => env('BITESHIP_ORIGIN_CONTACT_NAME', 'Store'),
        'origin_contact_phone' => env('BITESHIP_ORIGIN_CONTACT_PHONE', '080000000000'),
        'origin_address' => env('BITESHIP_ORIGIN_ADDRESS', 'Alamat Toko'),
        ],


];
