<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    protected $fillable = [
        'user_id',
        'customer_name_manual',
        'branch_id',
        'pos_session_id',
        'delivery_address',
        'delivery_postal_code',
        'delivery_recipient_name',
        'delivery_phone',
        'invoice_number',
        'transaction_source',
        'total_amount',
        'total_hpp',
        'shipping_cost',
        'payment_method',
        'payment_proof',
        'payment_status',
        'order_status',
        'shipping_courier',
        'shipping_service',
        'shipping_tracking_number',
        'biteship_order_id',
        'biteship_waybill_id',
        'paid_at',
    ];

    protected $casts = [
        'total_amount' => 'decimal:2',
        'total_hpp' => 'decimal:2',
        'shipping_cost' => 'decimal:2',
        'paid_at' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function items()
    {
        return $this->hasMany(OrderItem::class);
    }
}