<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class BiteshipRatesRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'origin_postal_code' => ['required', 'string'],
            'destination_postal_code' => ['required', 'string'],
            'couriers' => ['required', 'string'],
            'items' => ['required', 'array', 'min:1'],
            'items.*.name' => ['required', 'string'],
            'items.*.value' => ['required', 'numeric'],
            'items.*.weight' => ['required', 'numeric'],
            'items.*.quantity' => ['required', 'integer', 'min:1'],
        ];
    }
}