<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class BiteshipOrderRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'shipper_contact_name' => ['required', 'string'],
            'shipper_contact_phone' => ['required', 'string'],
            'shipper_contact_email' => ['required', 'email'],
            'shipper_organization' => ['nullable', 'string'],
            'origin_contact_name' => ['required', 'string'],
            'origin_contact_phone' => ['required', 'string'],
            'origin_address' => ['required', 'string'],
            'origin_postal_code' => ['required', 'string'],
            'origin_note' => ['nullable', 'string'],
            'destination_contact_name' => ['required', 'string'],
            'destination_contact_phone' => ['required', 'string'],
            'destination_contact_email' => ['nullable', 'email'],
            'destination_address' => ['required', 'string'],
            'destination_postal_code' => ['required', 'string'],
            'destination_note' => ['nullable', 'string'],
            'courier_company' => ['required', 'string'],
            'courier_type' => ['required', 'string'],
            'courier_insurance' => ['nullable', 'numeric'],
            'delivery_type' => ['nullable', 'string'],
            'delivery_date' => ['nullable', 'date'],
            'delivery_time' => ['nullable', 'string'],
            'items' => ['required', 'array', 'min:1'],
            'items.*.name' => ['required', 'string'],
            'items.*.value' => ['required', 'numeric'],
            'items.*.weight' => ['required', 'numeric'],
            'items.*.quantity' => ['required', 'integer', 'min:1'],
        ];
    }
}