<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class EnsureStaff
{
    public function handle(Request $request, Closure $next)
    {
        $user = $request->user();

        if (!$user || !$user->is_active || !$user->isStaff()) {
            // untuk API: kembalikan 403/401
            return response()->json([
                'message' => 'Unauthorized (not staff / inactive).'
            ], 403);
        }

        return $next($request);
    }
}