<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Wishlist;
use Illuminate\Http\Request;

class WishlistController extends Controller
{
    public function index()
    {
        $wishlists = Wishlist::with('user', 'product')->paginate(10);
        return response()->json($wishlists);
    }

    public function show(Wishlist $wishlist)
    {
        $wishlist->load('user', 'product');
        return response()->json($wishlist);
    }

    public function store(Request $request)
    {
        $request->validate([
            'user_id' => 'required|exists:users,id',
            'product_id' => 'required|exists:products,id',
        ]);

        $wishlist = Wishlist::create($request->all());
        return response()->json($wishlist, 201);
    }

    public function destroy(Wishlist $wishlist)
    {
        $wishlist->delete();
        return response()->json(['message' => 'Wishlist item deleted']);
    }
}