<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\UserVoucher;
use Illuminate\Http\Request;

class UserVoucherController extends Controller
{
    public function index()
    {
        $data = UserVoucher::with(['user', 'voucher', 'order'])
            ->latest('id')
            ->paginate(10);

        return response()->json($data);
    }

    public function show(UserVoucher $userVoucher)
    {
        $userVoucher->load(['user', 'voucher', 'order']);
        return response()->json($userVoucher);
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'user_id'          => ['required', 'integer', 'exists:users,id'],
            'voucher_id'       => ['required', 'integer', 'exists:vouchers,id'],
            'order_id'         => ['required', 'integer', 'exists:orders,id'],
            'discount_amount'  => ['required', 'numeric', 'min:0'],
        ]);

        $data = UserVoucher::create($validated);

        return response()->json($data, 201);
    }

    public function update(Request $request, UserVoucher $userVoucher)
    {
        $validated = $request->validate([
            'discount_amount' => ['sometimes', 'numeric', 'min:0'],
        ]);

        $userVoucher->update($validated);

        return response()->json($userVoucher);
    }

    public function destroy(UserVoucher $userVoucher)
    {
        $userVoucher->delete();
        return response()->json(['message' => 'User voucher deleted']);
    }
}