<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\UserAddress;
use Illuminate\Http\Request;

class UserAddressController extends Controller
{
    public function index(Request $request)
    {
        return $request->user()->addresses()->orderByDesc('is_primary')->get();
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'label'          => 'nullable|string|max:50',
            'recipient_name' => 'required|string|max:100',
            'phone_number'   => 'required|string|max:20',
            'address_full'   => 'required|string',
            'postal_code'    => 'required|string|max:10',
            'area_id'        => 'required|string'
        ]);

        $data['user_id'] = $request->user()->id;

        return UserAddress::create($data);
    }

    public function update(Request $request, $id)
    {
        $address = UserAddress::where('user_id', $request->user()->id)->findOrFail($id);

        $address->update($request->all());

        return response()->json(['message' => 'Alamat diperbarui']);
    }

    public function destroy(Request $request, $id)
    {
        UserAddress::where('user_id', $request->user()->id)
            ->where('id', $id)
            ->delete();

        return response()->json(['message' => 'Alamat dihapus']);
    }

    public function setPrimary(Request $request, $id)
    {
        UserAddress::where('user_id', $request->user()->id)->update(['is_primary' => 0]);

        UserAddress::where('id', $id)
            ->where('user_id', $request->user()->id)
            ->update(['is_primary' => 1]);

        return response()->json(['message' => 'Alamat utama diset']);
    }
}
