<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class UploadController extends Controller
{
    public function store(Request $request)
    {
        $request->validate([
            'file' => ['required', 'file', 'image', 'max:5120'], // max 5MB
        ]);

        // simpan ke storage/app/public/uploads/...
        $path = $request->file('file')->store('uploads', 'public');

        // url akses publik: /storage/uploads/....
        $url = asset('storage/' . $path);

        return response()->json([
            'path' => $path,
            'url' => $url,
        ]);
    }
}