<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\ProductReview;
use Illuminate\Http\Request;

class ProductReviewController extends Controller
{
    public function index()
    {
        $data = ProductReview::with(['user', 'product'])
            ->latest('id')
            ->paginate(10);

        return response()->json($data);
    }

    public function show(ProductReview $productReview)
    {
        $productReview->load(['user', 'product']);
        return response()->json($productReview);
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'user_id'    => ['required', 'integer', 'exists:users,id'],
            'product_id' => ['required', 'integer', 'exists:products,id'],
            'order_id'   => ['required', 'integer', 'exists:orders,id'],
            'rating'     => ['required', 'integer', 'min:1', 'max:5'],
            'comment'    => ['nullable', 'string'],
            'reply'      => ['nullable', 'string'],
            'image_url'  => ['nullable', 'string', 'max:255'],
        ]);

        $review = ProductReview::create($validated);

        return response()->json($review, 201);
    }

    public function update(Request $request, ProductReview $productReview)
    {
        $validated = $request->validate([
            'rating'    => ['sometimes', 'integer', 'min:1', 'max:5'],
            'comment'   => ['nullable', 'string'],
            'reply'     => ['nullable', 'string'],
            'image_url' => ['nullable', 'string', 'max:255'],
        ]);

        $productReview->update($validated);

        return response()->json($productReview);
    }

    public function destroy(ProductReview $productReview)
    {
        $productReview->delete();
        return response()->json(['message' => 'Product review deleted']);
    }
}