<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\ProductImage;
use Illuminate\Http\Request;

class ProductImageController extends Controller
{
    public function index()
    {
        $data = ProductImage::with('product')
            ->latest('id')
            ->paginate(10);

        return response()->json($data);
    }

    public function show(ProductImage $productImage)
    {
        $productImage->load('product');
        return response()->json($productImage);
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'product_id' => ['required', 'integer', 'exists:products,id'],
            'image_url'  => ['required', 'string', 'max:255'],
            'is_cover'   => ['nullable', 'boolean'],
        ]);

        $image = ProductImage::create($validated);

        return response()->json($image, 201);
    }

    public function update(Request $request, ProductImage $productImage)
    {
        $validated = $request->validate([
            'image_url' => ['sometimes', 'string', 'max:255'],
            'is_cover'  => ['nullable', 'boolean'],
        ]);

        $productImage->update($validated);

        return response()->json($productImage);
    }

    public function destroy(ProductImage $productImage)
    {
        $productImage->delete();
        return response()->json(['message' => 'Product image deleted']);
    }
}