<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\OtpVerification;
use Illuminate\Support\Facades\Mail;
use Carbon\Carbon;

class OtpVerificationController extends Controller
{
    /* ================= SEND OTP ================= */
    public function sendOtp(Request $request)
    {
        $request->validate([
            'email' => 'required|email'
        ]);

        $otp = rand(100000, 999999);

        OtpVerification::updateOrCreate(
            ['email' => $request->email],
            [
                'otp_code' => $otp,
                'expires_at' => Carbon::now()->addMinutes(5)
            ]
        );

        Mail::raw("Kode OTP Doremi Anda: {$otp}", function ($msg) use ($request) {
            $msg->to($request->email)
                ->subject('Kode OTP Doremi');
        });

        return response()->json([
            'message' => 'OTP berhasil dikirim'
        ]);
    }

    /* ================= VERIFY OTP ================= */
    public function verifyOtp(Request $request)
    {
        $request->validate([
            'email' => 'required|email',
            'otp' => 'required'
        ]);

        $otp = OtpVerification::where('email', $request->email)
            ->where('otp_code', $request->otp)
            ->where('expires_at', '>', now())
            ->first();

        if (!$otp) {
            return response()->json([
                'message' => 'OTP tidak valid atau kadaluarsa'
            ], 422);
        }

        return response()->json([
            'message' => 'OTP valid, lanjut lengkapi data'
        ]);
    }
}
