<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\NotificationSubscription;
use Illuminate\Http\Request;

class NotificationSubscriptionController extends Controller
{
    public function index()
    {
        $data = NotificationSubscription::with('user')
            ->latest('id')
            ->paginate(10);

        return response()->json($data);
    }

    public function show(NotificationSubscription $notificationSubscription)
    {
        $notificationSubscription->load('user');
        return response()->json($notificationSubscription);
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'user_id'  => ['required', 'integer', 'exists:users,id'],
            'endpoint' => ['required', 'string'],
            'p256dh'   => ['required', 'string'],
            'auth'     => ['required', 'string'],
        ]);

        $subscription = NotificationSubscription::create($validated);

        return response()->json($subscription, 201);
    }

    public function update(Request $request, NotificationSubscription $notificationSubscription)
    {
        $validated = $request->validate([
            'endpoint' => ['sometimes', 'string'],
            'p256dh'   => ['sometimes', 'string'],
            'auth'     => ['sometimes', 'string'],
        ]);

        $notificationSubscription->update($validated);

        return response()->json($notificationSubscription);
    }

    public function destroy(NotificationSubscription $notificationSubscription)
    {
        $notificationSubscription->delete();
        return response()->json(['message' => 'Notification subscription deleted']);
    }
}