<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Notification;
use Illuminate\Http\Request;

class NotificationController extends Controller
{
    public function index()
    {
        $data = Notification::with('user')
            ->latest('id')
            ->paginate(10);

        return response()->json($data);
    }

    public function show(Notification $notification)
    {
        $notification->load('user');
        return response()->json($notification);
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'user_id' => ['required', 'integer', 'exists:users,id'],
            'title'   => ['required', 'string', 'max:255'],
            'message' => ['required', 'string'],
            'type'    => ['nullable', 'string', 'max:50'],
            'is_read' => ['nullable', 'boolean'],
        ]);

        $notification = Notification::create($validated);

        return response()->json($notification, 201);
    }

    public function update(Request $request, Notification $notification)
    {
        $validated = $request->validate([
            'title'   => ['sometimes', 'string', 'max:255'],
            'message' => ['sometimes', 'string'],
            'type'    => ['nullable', 'string', 'max:50'],
            'is_read' => ['nullable', 'boolean'],
        ]);

        $notification->update($validated);

        return response()->json($notification);
    }

    public function destroy(Notification $notification)
    {
        $notification->delete();
        return response()->json(['message' => 'Notification deleted']);
    }
}