<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;

class CustomerController extends Controller
{
    public function index(Request $request)
    {
        $q = $request->query('q');
        $perPage = (int) $request->query('per_page', 10);

        $customers = User::query()
            ->where('role', 'customer')
            ->when($q, function ($query) use ($q) {
                $query->where(function ($sub) use ($q) {
                    $sub->where('name', 'like', "%{$q}%")
                        ->orWhere('email', 'like', "%{$q}%")
                        ->orWhere('phone', 'like', "%{$q}%");
                });
            })
            ->withCount('orders')
            ->withSum('orders as total_spent', 'total_amount') // <- ganti kalau nama kolom beda
            ->orderByDesc('id')
            ->paginate($perPage);

        return response()->json($customers);
    }

public function show($id)
{
    $customer = User::with(['orders' => function($query) {
        $query->orderBy('created_at', 'desc');
    }])->findOrFail($id);

    // Menghitung total belanja dari semua order yang statusnya bukan 'cancelled'
    $totalSpent = $customer->orders
        ->whereNotIn('order_status', ['cancelled'])
        ->sum('total_amount');

    // Menghitung total item yang pernah dibeli
    $totalItemsBought = \DB::table('order_items')
        ->join('orders', 'order_items.order_id', '=', 'orders.id')
        ->where('orders.user_id', $id)
        ->where('orders.order_status', '!=', 'cancelled')
        ->sum('order_items.quantity');

    return response()->json([
        'status' => 'success',
        'data' => [
            'id' => $customer->id,
            'name' => $customer->name,
            'email' => $customer->email,
            'phone' => $customer->phone,
            'address' => $customer->address, // Pastikan field ini ada di tabel users
            'total_spent' => $totalSpent,
            'total_items_count' => $totalItemsBought,
            'orders_count' => $customer->orders->count(),
            'orders' => $customer->orders->map(function($order) {
                return [
                    'id' => $order->id,
                    'invoice_number' => $order->invoice_number,
                    'total_price' => $order->total_amount,
                    'payment_method' => $order->payment_method ?? 'Belum Pilih',
                    'order_status' => $order->order_status,
                    'payment_status' => $order->payment_status,
                    'created_at' => $order->created_at,
                    'items_count' => \DB::table('order_items')->where('order_id', $order->id)->sum('quantity')
                ];
            })
        ]
    ]);
}
}