<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Brand;
use Illuminate\Http\Request;

class BrandController extends Controller
{
    public function index(Request $request)
    {
        $query = Brand::query();

        // filter berdasarkan category jika ada
        if ($request->filled('category_id')) {
            $query->whereIn('id', function ($q) use ($request) {
                $q->select('brand_id')
                  ->from('products')
                  ->whereNotNull('brand_id')
                  ->where('category_id', $request->category_id);
            });
        }

        return response()->json([
            'data' => $query->orderBy('name')->get()
        ]);
    }

    public function store(Request $request)
{
    $data = $request->validate([
        'name' => 'required|string|max:100|unique:brands,name'
    ]);

    $data['slug'] = \Str::slug($data['name']);

    return response()->json(
        Brand::create($data),
        201
    );
}

}
