<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Branch;
use Illuminate\Http\Request;

class BranchController extends Controller
{
    public function index()
    {
        $branches = Branch::paginate(10);
        return response()->json($branches);
    }

    public function show(Branch $branch)
    {
        $branch->load('users', 'orders');
        return response()->json($branch);
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:100',
            'address' => 'nullable|string',
            'city_id' => 'nullable|string',
            'district_id' => 'nullable|string',
            'phone' => 'nullable|string|max:20',
            'is_center' => 'boolean',
            'is_active' => 'boolean',
        ]);

        $branch = Branch::create($request->all());
        return response()->json($branch, 201);
    }

    public function update(Request $request, Branch $branch)
    {
        $request->validate([
            'name' => 'sometimes|string|max:100',
            'address' => 'nullable|string',
            'city_id' => 'nullable|string',
            'district_id' => 'nullable|string',
            'phone' => 'nullable|string|max:20',
            'is_center' => 'boolean',
            'is_active' => 'boolean',
        ]);

        $branch->update($request->all());
        return response()->json($branch);
    }

    public function destroy(Branch $branch)
    {
        $branch->delete();
        return response()->json(['message' => 'Branch deleted']);
    }
}