<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\BankAccount;
use Illuminate\Http\Request;

class BankAccountController extends Controller
{
    public function index()
    {
        $accounts = BankAccount::paginate(10);
        return response()->json($accounts);
    }

    public function show(BankAccount $bankAccount)
    {
        return response()->json($bankAccount);
    }

    public function store(Request $request)
    {
        $request->validate([
            'bank_name' => 'required|string|max:50',
            'bank_logo' => 'nullable|string',
            'account_number' => 'required|string|max:50',
            'account_holder' => 'required|string|max:100',
            'is_active' => 'boolean',
        ]);

        $account = BankAccount::create($request->all());
        return response()->json($account, 201);
    }

    public function update(Request $request, BankAccount $bankAccount)
    {
        $request->validate([
            'bank_name' => 'sometimes|string|max:50',
            'bank_logo' => 'nullable|string',
            'account_number' => 'sometimes|string|max:50',
            'account_holder' => 'sometimes|string|max:100',
            'is_active' => 'boolean',
        ]);

        $bankAccount->update($request->all());
        return response()->json($bankAccount);
    }

    public function destroy(BankAccount $bankAccount)
    {
        $bankAccount->delete();
        return response()->json(['message' => 'Bank account deleted']);
    }
}