<?php

namespace App\Services;

use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Http;

class BiteshipService
{
    private function client()
    {
        $key = env('BITESHIP_API_KEY');

        return Http::baseUrl('https://api.biteship.com')
            ->withHeaders([
                'Authorization' => $key,
                'Content-Type'  => 'application/json',
                'Accept'        => 'application/json',
            ])
            ->timeout(30);
    }

    public function activeCourierCodes(): array
    {
        return Cache::remember('biteship_active_couriers', now()->addHours(6), function () {
            $res = $this->client()->get('/v1/couriers')->throw()->json();

            $list = $res['couriers'] ?? $res['data']['couriers'] ?? $res['data'] ?? [];
            if (!is_array($list)) $list = [];

            $codes = [];
            foreach ($list as $c) {
                $code = strtolower(trim((string)($c['courier_code'] ?? $c['code'] ?? '')));
                $active = $c['is_active'] ?? $c['active'] ?? true;

                if ($code && $active) $codes[] = $code;
            }

            $codes = array_values(array_unique($codes));

            if (count($codes) === 0) {
                $codes = ['jne', 'sicepat', 'anteraja'];
            }

            return $codes;
        });
    }

    public function rates(array $payload): array
    {
        $couriers = trim((string)($payload['couriers'] ?? ''));
        if ($couriers === '') {
            $payload['couriers'] = implode(',', $this->activeCourierCodes());
        }

        // ✅ Payload dikirim apa adanya -> dimensi akan ikut (length/width/height)
        return $this->client()
            ->post('/v1/rates/couriers', $payload)
            ->throw()
            ->json();
    }
}
