<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserAddress extends Model
{
    use HasFactory;

    protected $fillable = [
    'user_id',
    'label',
    'recipient_name',
    'phone_number',
    'address_full',
    'province_id',
    'city_id',
    'district_id',
    'postal_code',
    'area_id',
    'is_primary'
    ];


    public function user()
    {
        return $this->belongsTo(User::class);
    }
}