<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductVariant extends Model
{
    use HasFactory;

    // ✅ JANGAN ADA image_url di sini (karena kolomnya di product_images)
    protected $fillable = [
        'product_id',
        'name',
        'price',
        'hpp',
        'stock',
        'sku',
    ];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    // ✅ relasi gambar varian
    public function images()
    {
        return $this->hasMany(ProductImage::class, 'variant_id');
    }

    public function carts()
    {
        return $this->hasMany(Cart::class);
    }

    public function orderItems()
    {
        return $this->hasMany(OrderItem::class);
    }

    public function stocks()
    {
        return $this->hasMany(ProductBranchStock::class);
    }
}
