<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ChatRoom extends Model
{
    protected $fillable = ['customer_user_id','assigned_admin_id','status','last_message_at'];

    protected $casts = ['last_message_at' => 'datetime'];

    public function customer() { return $this->belongsTo(User::class, 'customer_user_id'); }
    public function assignedAdmin() { return $this->belongsTo(User::class, 'assigned_admin_id'); }
    public function messages() { return $this->hasMany(ChatMessage::class, 'room_id'); }
}