<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Branch extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'address',
        'city_id',
        'district_id',
        'phone',
        'is_center',
        'is_active',
    ];

    public function users()
    {
        return $this->hasMany(User::class);
    }

    public function orders()
    {
        return $this->hasMany(Order::class);
    }

    public function posSessions()
    {
        return $this->hasMany(PosSession::class);
    }

    public function productStocks()
    {
        return $this->hasMany(ProductBranchStock::class);
    }
}