<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class OtpMail extends Mailable
{
    use Queueable, SerializesModels;

    public function __construct(
        public string $otp,
        public string $title = 'Kode OTP Doremi',
        public string $purposeText = 'Verifikasi'
    ) {}

    public function build()
    {
        return $this->subject($this->title)
            ->view('emails.otp')
            ->with([
                'otp' => $this->otp,
                'purposeText' => $this->purposeText,
            ]);
    }
}
