<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class OrderDeliveredMail extends Mailable
{
    use Queueable, SerializesModels;

    public function __construct(public array $data) {}

    public function build()
    {
        return $this->subject("Pesanan Sudah Sampai - Order #".$this->data['order_id'])
            ->view('emails.order_delivered')
            ->with($this->data);
    }
}
