<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class LoginRequest extends FormRequest
{
    public function authorize(): bool { return true; }

    public function rules(): array
    {
        return [
            'email' => ['required','email:rfc,dns','max:190'],
            'password' => ['required','string','min:8','max:72'],
            'device_name' => ['nullable','string','max:64'],
        ];
    }
}
