<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class BiteshipRatesRequest extends FormRequest
{
    public function authorize(): bool { return true; }

    public function rules(): array
    {
        return [
            'origin_postal_code' => ['required', 'string'],
            'destination_postal_code' => ['required', 'string'],

            // ✅ JANGAN required. Biar backend yang isi dari Biteship active couriers.
            'couriers' => ['nullable', 'string'],

            'items' => ['required', 'array', 'min:1'],
            'items.*.name' => ['required', 'string'],
            'items.*.value' => ['nullable', 'numeric', 'min:0'],
            'items.*.weight' => ['required', 'numeric', 'min:1'],
            'items.*.quantity' => ['required', 'integer', 'min:1'],

            // ✅ TAMBAHAN VOLUMETRIK (cm)
            // Biteship akan pakai volumetrik kalau ketiganya ada & > 0
            'items.*.length' => ['nullable', 'numeric', 'min:1'],
            'items.*.width'  => ['nullable', 'numeric', 'min:1'],
            'items.*.height' => ['nullable', 'numeric', 'min:1'],
        ];
    }
}
