<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class BiteshipOrderRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Normalisasi input:
     * - courier_company & courier_type selalu lowercase + trim
     * - mapping beberapa istilah umum -> kode biteship
     */
    protected function prepareForValidation(): void
    {
        $company = strtolower(trim((string) $this->input('courier_company', '')));
        $typeRaw = strtolower(trim((string) $this->input('courier_type', '')));

        // mapping service umum -> biteship code
        $typeMap = [
            'reguler' => 'reg',
            'regular' => 'reg',
            'reg' => 'reg',
        ];
        $type = $typeMap[$typeRaw] ?? $typeRaw;

        $this->merge([
            'shipper_contact_name' => trim((string) $this->input('shipper_contact_name', '')),
            'shipper_contact_phone' => trim((string) $this->input('shipper_contact_phone', '')),
            'shipper_contact_email' => $this->input('shipper_contact_email'),
            'shipper_organization' => $this->input('shipper_organization'),

            'origin_contact_name' => trim((string) $this->input('origin_contact_name', '')),
            'origin_contact_phone' => trim((string) $this->input('origin_contact_phone', '')),
            'origin_address' => trim((string) $this->input('origin_address', '')),
            'origin_postal_code' => trim((string) $this->input('origin_postal_code', '')),
            'origin_note' => $this->input('origin_note'),

            'destination_contact_name' => trim((string) $this->input('destination_contact_name', '')),
            'destination_contact_phone' => trim((string) $this->input('destination_contact_phone', '')),
            'destination_contact_email' => $this->input('destination_contact_email'),
            'destination_address' => trim((string) $this->input('destination_address', '')),
            'destination_postal_code' => trim((string) $this->input('destination_postal_code', '')),
            'destination_note' => $this->input('destination_note'),

            // ✅ pastikan yang masuk: courier_code + service_code
            'courier_company' => $company,
            'courier_type' => $type,
        ]);
    }

    public function rules(): array
    {
        return [
            'shipper_contact_name' => ['required', 'string'],
            'shipper_contact_phone' => ['required', 'string'],
            'shipper_contact_email' => ['nullable', 'email'],
            'shipper_organization' => ['nullable', 'string'],

            'origin_contact_name' => ['required', 'string'],
            'origin_contact_phone' => ['required', 'string'],
            'origin_address' => ['required', 'string'],
            'origin_postal_code' => ['required', 'string', 'min:5'],
            'origin_note' => ['nullable', 'string'],

            'destination_contact_name' => ['required', 'string'],
            'destination_contact_phone' => ['required', 'string'],
            'destination_contact_email' => ['nullable', 'email'],
            'destination_address' => ['required', 'string'],
            'destination_postal_code' => ['required', 'string', 'min:5'],
            'destination_note' => ['nullable', 'string'],

            'courier_company' => ['required', 'string'],
            'courier_type' => ['required', 'string'],
            'courier_insurance' => ['nullable', 'numeric', 'min:0'],

            'delivery_type' => ['nullable', 'string'],
            'delivery_date' => ['nullable', 'date'],
            'delivery_time' => ['nullable', 'string'],

            'items' => ['required', 'array', 'min:1'],
            'items.*.name' => ['required', 'string'],
            'items.*.value' => ['required', 'numeric', 'min:0'],
            'items.*.weight' => ['required', 'numeric', 'min:1'],
            'items.*.quantity' => ['required', 'integer', 'min:1'],

            // ✅ TAMBAHAN VOLUMETRIK (cm) - optional
            // Biteship akan pakai volumetrik kalau length/width/height tersedia & > 0
            'items.*.length' => ['nullable', 'numeric', 'min:1'],
            'items.*.width'  => ['nullable', 'numeric', 'min:1'],
            'items.*.height' => ['nullable', 'numeric', 'min:1'],
        ];
    }
}
