<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class StaffOnly
{
    public function handle(Request $request, Closure $next)
    {
        $user = $request->user();
        if (!$user) {
            return response()->json(['message' => 'Unauthenticated'], 401);
        }

        $staffRoles = ['super_admin','admin','inventory','cs','marketing'];

        if (!in_array($user->role, $staffRoles, true)) {
            return response()->json(['message' => 'Forbidden'], 403);
        }

        if (!$user->is_active) {
            return response()->json(['message' => 'Account inactive'], 403);
        }

        return $next($request);
    }
}
