<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class SecurityHeaders
{
    public function handle(Request $request, Closure $next): Response
    {
        /** @var Response $response */
        $response = $next($request);

        // HSTS hanya untuk HTTPS (aktifkan setelah yakin TLS sudah benar)
        if ($request->isSecure()) {
            $response->headers->set('Strict-Transport-Security', 'max-age=31536000; includeSubDomains; preload');
        }

        // Anti sniffing & clickjacking
        $response->headers->set('X-Content-Type-Options', 'nosniff');
        $response->headers->set('X-Frame-Options', 'DENY');

        // Referrer policy
        $response->headers->set('Referrer-Policy', 'no-referrer');

        // Permissions policy (matikan yang tidak perlu)
        $response->headers->set('Permissions-Policy', 'geolocation=(), microphone=(), camera=()');

        // CSP untuk API: tetap bagus untuk browser clients (SPA) jika ada
        // Sesuaikan jika kamu serve docs/Swagger dsb.
        $csp = "default-src 'none'; frame-ancestors 'none'; base-uri 'none'; form-action 'none'";
        $response->headers->set('Content-Security-Policy', $csp);

        return $response;
    }
}
