<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class RequireRole
{
    public function handle(Request $request, Closure $next, string $roles)
    {
        $user = $request->user();
        if (!$user) {
            return response()->json(['message' => 'Unauthenticated'], 401);
        }

        $allowed = array_map('trim', explode('|', $roles));

        // multi-role: cek apakah user punya salah satu role
        $hasRole = $user->roles()->whereIn('slug', $allowed)->exists();

        // fallback jika Anda masih simpan single role_id / enum role
        if (!$hasRole && isset($user->role) && in_array($user->role, $allowed, true)) {
            $hasRole = true;
        }

        if (!$hasRole) {
            return response()->json([
                'message' => 'Forbidden',
                'required_roles' => $allowed
            ], 403);
        }

        return $next($request);
    }
}