<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\UserAddress;
use Illuminate\Http\Request;

class UserAddressController extends Controller
{
    public function index(Request $request)
    {
        return $request->user()
            ->addresses()
            ->orderByDesc('is_primary')
            ->latest()
            ->get();
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'label'          => 'nullable|string|max:50',
            'recipient_name' => 'required|string|max:100',
            'phone_number'   => 'required|string|max:20',
            'address_full'   => 'required|string',
            'province_id'    => 'nullable|string|max:50',
            'city_id'        => 'nullable|string|max:50',
            'district_id'    => 'nullable|string|max:50',
            'postal_code'    => 'required|string|max:10',
            'area_id'        => 'nullable|string|max:100',
            'lat'            => 'nullable|string|max:50',
            'lng'            => 'nullable|string|max:50',
            'is_primary'     => 'nullable|boolean',
        ]);

        $data['user_id'] = $request->user()->id;
        $data['label'] = $data['label'] ?? 'Rumah';

        // jika set primary, nol-kan lainnya
        $isPrimary = (int) (!!($data['is_primary'] ?? false));
        $data['is_primary'] = $isPrimary;

        if ($isPrimary === 1) {
            UserAddress::where('user_id', $data['user_id'])->update(['is_primary' => 0]);
        }

        return UserAddress::create($data);
    }

    public function update(Request $request, $id)
    {
        $address = UserAddress::where('user_id', $request->user()->id)->findOrFail($id);

        $data = $request->validate([
            'label'          => 'nullable|string|max:50',
            'recipient_name' => 'required|string|max:100',
            'phone_number'   => 'required|string|max:20',
            'address_full'   => 'required|string',
            'province_id'    => 'nullable|string|max:50',
            'city_id'        => 'nullable|string|max:50',
            'district_id'    => 'nullable|string|max:50',
            'postal_code'    => 'required|string|max:10',
            'area_id'        => 'nullable|string|max:100',
            'lat'            => 'nullable|string|max:50',
            'lng'            => 'nullable|string|max:50',
            'is_primary'     => 'nullable|boolean',
        ]);

        $isPrimary = array_key_exists('is_primary', $data) ? (int) (!!$data['is_primary']) : null;

        if ($isPrimary === 1) {
            UserAddress::where('user_id', $request->user()->id)->update(['is_primary' => 0]);
            $data['is_primary'] = 1;
        } elseif ($isPrimary === 0) {
            $data['is_primary'] = 0;
        } else {
            unset($data['is_primary']);
        }

        $address->update($data);

        return response()->json(['message' => 'Alamat diperbarui']);
    }

    public function destroy(Request $request, $id)
    {
        UserAddress::where('user_id', $request->user()->id)
            ->where('id', $id)
            ->delete();

        return response()->json(['message' => 'Alamat dihapus']);
    }

    public function setPrimary(Request $request, $id)
    {
        UserAddress::where('user_id', $request->user()->id)->update(['is_primary' => 0]);

        UserAddress::where('id', $id)
            ->where('user_id', $request->user()->id)
            ->update(['is_primary' => 1]);

        return response()->json(['message' => 'Alamat utama diset']);
    }
}
