<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class UploadController extends Controller
{
    public function store(Request $request)
    {
        $request->validate([
            // React: fd.append("file", file)
            'file' => ['required', 'file', 'image', 'mimes:jpg,jpeg,png,webp,gif', 'max:5120'], // 5MB
        ]);

        $file = $request->file('file');

        // Rapiin folder per bulan (opsional)
        $subDir = 'uploads/' . date('Y/m'); // uploads/2026/01
        // Kalau mau 1 folder aja: $subDir = 'uploads';

        $targetDir = public_path($subDir);

        // Pastikan folder ada
        if (!is_dir($targetDir)) {
            @mkdir($targetDir, 0775, true);
        }

        // Nama file unik
        $ext = strtolower($file->getClientOriginalExtension() ?: $file->guessExtension() ?: 'jpg');
        $filename = Str::uuid()->toString() . '.' . $ext;

        // Simpan ke public/uploads/...
        $file->move($targetDir, $filename);

        // Path relatif yang bisa kamu simpan di DB
        $relativePath = $subDir . '/' . $filename; // uploads/2026/01/uuid.webp

        /**
         * URL publik:
         * - PAKAI request host biar tidak tergantung APP_URL (sering salah set).
         * - Hasil: https://api.jts14.my.id/uploads/2026/01/uuid.webp
         */
        $base = $request->getSchemeAndHttpHost();
        $url  = $base . '/' . ltrim($relativePath, '/');

        return response()->json([
            'success' => true,
            'path'    => $relativePath,
            'url'     => $url,
        ], 201);
    }
}
