<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Setting;
use Illuminate\Http\Request;

class SettingController extends Controller
{
    public function index()
    {
        $settings = Setting::paginate(10);
        return response()->json($settings);
    }

    public function show(Setting $setting)
    {
        return response()->json($setting);
    }

    public function store(Request $request)
    {
        $request->validate([
            'key_name' => 'required|string|max:50|unique:settings',
            'value' => 'nullable|string',
        ]);

        $setting = Setting::create($request->all());
        return response()->json($setting, 201);
    }

    public function update(Request $request, Setting $setting)
    {
        $request->validate([
            'key_name' => 'sometimes|string|max:50|unique:settings,key_name,' . $setting->id,
            'value' => 'nullable|string',
        ]);

        $setting->update($request->all());
        return response()->json($setting);
    }

    public function destroy(Setting $setting)
    {
        $setting->delete();
        return response()->json(['message' => 'Setting deleted']);
    }
}