<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class ProductReviewController extends Controller
{
    /**
     * GET /api/product-reviews
     * (Kalau kamu belum butuh list public, aman kembalikan array kosong)
     */
    public function index()
    {
        // Kalau kamu punya model review, ganti dengan query yang sesuai.
        return response()->json([]);
    }

    /**
     * GET /api/product-reviews/me
     * Dipakai OrdersPage.jsx
     */
    public function myReviews(Request $request)
    {
        $user = $request->user();
        if (!$user) {
            return response()->json(['message' => 'Unauthenticated'], 401);
        }

        // GANTI model ini kalau namanya berbeda di project kamu
        $model = '\\App\\Models\\ProductReview';

        if (!class_exists($model)) {
            // biar tidak 500 kalau model belum ada
            return response()->json([]);
        }

        $reviews = $model::query()
            ->where('user_id', $user->id)
            ->latest('id')
            ->get();

        return response()->json($reviews);
    }

    /**
     * POST /api/product-reviews
     * Placeholder aman (biar route tidak 500)
     */
    public function store(Request $request)
    {
        return response()->json(['message' => 'Not implemented'], 501);
    }

    /**
     * PUT /api/product-reviews/{productReview}
     */
    public function update(Request $request, $productReview)
    {
        return response()->json(['message' => 'Not implemented'], 501);
    }

    /**
     * DELETE /api/product-reviews/{productReview}
     */
    public function destroy($productReview)
    {
        return response()->json(['message' => 'Not implemented'], 501);
    }

    /**
     * PATCH /api/product-reviews/{productReview}/reply
     */
    public function reply(Request $request, $productReview)
    {
        return response()->json(['message' => 'Not implemented'], 501);
    }

    /**
     * GET /api/product-reviews/{productReview}
     */
    public function show($productReview)
    {
        return response()->json(['message' => 'Not implemented'], 501);
    }
}
