<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\ProductBranchStock;
use Illuminate\Http\Request;

class ProductBranchStockController extends Controller
{
    public function index()
    {
        $data = ProductBranchStock::with(['branch', 'product', 'variant'])
            ->latest('id')
            ->paginate(10);

        return response()->json($data);
    }

    public function show(ProductBranchStock $productBranchStock)
    {
        $productBranchStock->load(['branch', 'product', 'variant']);
        return response()->json($productBranchStock);
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'branch_id'  => ['required', 'integer', 'exists:branches,id'],
            'product_id' => ['required', 'integer', 'exists:products,id'],
            'variant_id' => ['required', 'integer', 'exists:product_variants,id'],
            'stock'      => ['required', 'integer', 'min:0'],
        ]);

        // unique_stock (branch_id, variant_id) -> aman pakai updateOrCreate
        $stock = ProductBranchStock::updateOrCreate(
            ['branch_id' => $validated['branch_id'], 'variant_id' => $validated['variant_id']],
            ['product_id' => $validated['product_id'], 'stock' => $validated['stock']]
        );

        return response()->json($stock, 201);
    }

    public function update(Request $request, ProductBranchStock $productBranchStock)
    {
        $validated = $request->validate([
            'stock' => ['sometimes', 'integer', 'min:0'],
        ]);

        $productBranchStock->update($validated);

        return response()->json($productBranchStock);
    }

    public function destroy(ProductBranchStock $productBranchStock)
    {
        $productBranchStock->delete();
        return response()->json(['message' => 'Product branch stock deleted']);
    }
}