<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\PasswordReset;
use Illuminate\Http\Request;

class PasswordResetController extends Controller
{
    public function index()
    {
        $data = PasswordReset::latest('id')->paginate(10);
        return response()->json($data);
    }

    public function show(PasswordReset $passwordReset)
    {
        return response()->json($passwordReset);
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'email'      => ['required', 'email', 'max:100'],
            'token'      => ['required', 'string', 'max:255'],
            'expires_at' => ['required', 'date'],
        ]);

        $reset = PasswordReset::create($validated);

        return response()->json($reset, 201);
    }

    public function update(Request $request, PasswordReset $passwordReset)
    {
        $validated = $request->validate([
            'email'      => ['sometimes', 'email', 'max:100'],
            'token'      => ['sometimes', 'string', 'max:255'],
            'expires_at' => ['sometimes', 'date'],
        ]);

        $passwordReset->update($validated);

        return response()->json($passwordReset);
    }

    public function destroy(PasswordReset $passwordReset)
    {
        $passwordReset->delete();
        return response()->json(['message' => 'Password reset deleted']);
    }
}