<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\OrderItem;
use Illuminate\Http\Request;

class OrderItemController extends Controller
{
    public function index()
    {
        $items = OrderItem::with('order', 'product', 'variant')->paginate(10);
        return response()->json($items);
    }

    public function show(OrderItem $orderItem)
    {
        $orderItem->load('order', 'product', 'variant');
        return response()->json($orderItem);
    }

    public function store(Request $request)
    {
        $request->validate([
            'order_id' => 'required|exists:orders,id',
            'product_id' => 'required|exists:products,id',
            'variant_id' => 'required|exists:product_variants,id',
            'product_name' => 'required|string|max:200',
            'variant_name' => 'required|string|max:100',
            'quantity' => 'required|integer|min:1',
            'price' => 'required|numeric|min:0',
            'hpp' => 'required|numeric|min:0',
        ]);

        $item = OrderItem::create($request->all());
        return response()->json($item, 201);
    }

    public function update(Request $request, OrderItem $orderItem)
    {
        $request->validate([
            'product_name' => 'sometimes|string|max:200',
            'variant_name' => 'sometimes|string|max:100',
            'quantity' => 'sometimes|integer|min:1',
            'price' => 'sometimes|numeric|min:0',
            'hpp' => 'sometimes|numeric|min:0',
        ]);

        $orderItem->update($request->all());
        return response()->json($orderItem);
    }

    public function destroy(OrderItem $orderItem)
    {
        $orderItem->delete();
        return response()->json(['message' => 'Order item deleted']);
    }
}