<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Mail\InvoiceMail;
use App\Mail\OrderDeliveredMail;
use App\Mail\TransactionStatusMail;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class OrderEmailController extends Controller
{
    /**
     * Kirim status transaksi: success|failed|pending|expired|refunded|canceled dll
     */
    public function transactionStatus(Request $request)
    {
        $request->validate([
            'email' => ['required','email'],
            'order_id' => ['required','string'],
            'status' => ['required','string'], // bebas sesuai kebutuhan
            'payment_ref' => ['nullable','string'],
            'customer_name' => ['nullable','string'],
            'message' => ['nullable','string'],
            'time' => ['nullable','string'],
        ]);

        Mail::to($request->email)->send(new TransactionStatusMail($request->all()));

        return response()->json(['message' => 'Email status transaksi terkirim']);
    }

    /**
     * Kirim email invoice/biaya
     */
    public function invoice(Request $request)
    {
        $request->validate([
            'email' => ['required','email'],
            'order_id' => ['required','string'],
            'customer_name' => ['nullable','string'],
            'items' => ['required','array'],
            'items.*.name' => ['required','string'],
            'items.*.qty' => ['required','integer','min:1'],
            'items.*.price' => ['required','numeric','min:0'],

            'subtotal' => ['required','numeric','min:0'],
            'shipping' => ['required','numeric','min:0'],
            'admin_fee' => ['nullable','numeric','min:0'],
            'discount' => ['nullable','numeric','min:0'],
            'total' => ['required','numeric','min:0'],
            'payment_status' => ['nullable','string'],
        ]);

        $data = $request->all();
        $data['admin_fee'] = $data['admin_fee'] ?? 0;
        $data['discount'] = $data['discount'] ?? 0;

        Mail::to($request->email)->send(new InvoiceMail($data));

        return response()->json(['message' => 'Email invoice terkirim']);
    }

    /**
     * Kirim email pesanan delivered
     */
    public function delivered(Request $request)
    {
        $request->validate([
            'email' => ['required','email'],
            'order_id' => ['required','string'],
            'customer_name' => ['nullable','string'],
            'courier' => ['nullable','string'],
            'tracking_number' => ['nullable','string'],
            'delivered_at' => ['nullable','string'],
        ]);

        Mail::to($request->email)->send(new OrderDeliveredMail($request->all()));

        return response()->json(['message' => 'Email delivered terkirim']);
    }
}
