<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class MeController extends Controller
{
    public function me(Request $request)
    {
        $u = $request->user();

        $roles = $u->roles()->pluck('slug')->values();
        $permissions = $u->roles()
            ->with('permissions:id,slug')
            ->get()
            ->flatMap(fn($r) => $r->permissions->pluck('slug'))
            ->unique()
            ->values();

        return response()->json([
            'data' => [
                'id' => $u->id,
                'name' => $u->name,
                'email' => $u->email,
                'roles' => $roles,
                'permissions' => $permissions,
            ]
        ]);
    }
}