<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Cart;
use Illuminate\Support\Facades\DB;

class CartController extends Controller
{
    public function index()
    {
        return Cart::with('product', 'variant')
            ->where('user_id', auth()->id())
            ->get();
    }

    public function store(Request $request)
    {
        $request->validate([
            'product_id' => 'required|integer',
            'variant_id' => 'required|integer',
            'quantity'   => 'required|integer|min:1',
        ]);

        $cart = Cart::updateOrCreate(
            [
                'user_id'    => auth()->id(),
                'product_id' => $request->product_id,
                'variant_id' => $request->variant_id,
            ],
            [
                // 🔥 INI KUNCINYA
                'quantity' => DB::raw('quantity + '.$request->quantity),
            ]
        );

        return response()->json([
    'success' => true,
    'cart' => $cart->load('product', 'variant')
]);

    }

    public function update(Request $request, Cart $cart)
    {
        $request->validate([
            'quantity' => 'required|integer|min:1',
        ]);

        $cart->update([
            'quantity' => $request->quantity,
        ]);

        return response()->json($cart);
    }

    public function destroy(Cart $cart)
    {
        $cart->delete();
        return response()->json(['success' => true]);
    }
}
