<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Brand;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class BrandController extends Controller
{
    public function index(Request $request)
    {
        $query = Brand::query();

        // filter berdasarkan category jika ada
        if ($request->filled('category_id')) {
            $query->whereIn('id', function ($q) use ($request) {
                $q->select('brand_id')
                  ->from('products')
                  ->whereNotNull('brand_id')
                  ->where('category_id', $request->category_id);
            });
        }

        $data = $query->orderBy('name')->get();

        return response()->json([
            'data' => $data
        ]);
    }

    public function show($id)
    {
        $brand = Brand::findOrFail($id);
        return response()->json(['data' => $brand]);
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'name' => 'required|string|max:100|unique:brands,name'
        ]);

        $data['slug'] = Str::slug($data['name']);

        $brand = Brand::create($data);

        return response()->json(['data' => $brand], 201);
    }

    public function update(Request $request, $id)
    {
        $brand = Brand::findOrFail($id);

        $data = $request->validate([
            'name' => 'required|string|max:100|unique:brands,name,' . $brand->id
        ]);

        $data['slug'] = Str::slug($data['name']);

        $brand->update($data);

        return response()->json(['data' => $brand]);
    }

    public function destroy($id)
    {
        $brand = Brand::findOrFail($id);
        $brand->delete();

        return response()->json(['message' => 'Brand deleted']);
    }
}
    