<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class AddressSearchController extends Controller
{
    public function search(Request $request)
    {
        $q = trim((string) $request->query('search', ''));
        if (mb_strlen($q) < 3) {
            return response()->json([
                'data' => [],
                'message' => 'Minimal 3 karakter untuk pencarian',
            ]);
        }

        $base = rtrim(config('services.biteship.base_url', env('BITESHIP_BASE_URL', 'https://api.biteship.com')), '/');
        $key  = env('BITESHIP_API_KEY');

        if (!$key) {
            return response()->json(['message' => 'BITESHIP_API_KEY belum diset'], 500);
        }

        // Endpoint Biteship untuk area biasanya seperti:
        // GET /v1/maps/areas?countries=ID&input=xxx
        // (nama path bisa beda tergantung implementasi kamu)
        $resp = Http::withHeaders([
            'Authorization' => $key,
            'Content-Type'  => 'application/json',
        ])->get($base . '/v1/maps/areas', [
            'countries' => 'ID',
            'input'     => $q,
            'type'      => 'single', // optional
        ]);

        if (!$resp->ok()) {
            return response()->json([
                'message' => 'Gagal mencari alamat',
                'detail'  => $resp->json(),
            ], 500);
        }

        // Normalisasi output biar frontend gampang
        $rows = $resp->json('areas') ?? $resp->json('data') ?? [];

        $data = collect($rows)->map(function ($it) {
            return [
                'id'           => $it['id'] ?? $it['area_id'] ?? null, // area_id
                'name'         => $it['name'] ?? $it['label'] ?? '',
                'administrative_division_level_1' => $it['administrative_division_level_1'] ?? null, // provinsi
                'administrative_division_level_2' => $it['administrative_division_level_2'] ?? null, // kota/kab
                'administrative_division_level_3' => $it['administrative_division_level_3'] ?? null, // kecamatan
                'postal_code'  => $it['postal_code'] ?? null,
                'latitude'     => $it['latitude'] ?? null,
                'longitude'    => $it['longitude'] ?? null,
            ];
        })->values();

        return response()->json(['data' => $data]);
    }
}
